/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.mist.message;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.jni.mist.message.JNIDeviceMessage;
import gov.nasa.gsfc.gmsec.api.jni.mist.message.JNIMistMessage;
import gov.nasa.gsfc.gmsec.api.mist.Device;
import gov.nasa.gsfc.gmsec.api.mist.DeviceIterator;
import gov.nasa.gsfc.gmsec.api.mist.Specification;
import gov.nasa.gsfc.gmsec.api.mist.message.MistMessage;

public class DeviceMessage
extends MistMessage {
    public DeviceMessage(JNIDeviceMessage jNIDeviceMessage) {
        super(jNIDeviceMessage);
    }

    public DeviceMessage(String string, Specification specification) throws IllegalArgumentException {
        super((JNIMistMessage)null);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject cannot be null, nor an empty string");
        }
        if (specification == null) {
            throw new IllegalArgumentException("Specification cannot be null");
        }
        this.registerChild(new JNIDeviceMessage(string, Specification.getInternal(specification)));
    }

    public DeviceMessage(String string, Config config, Specification specification) throws IllegalArgumentException {
        super((JNIMistMessage)null);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject cannot be null, nor an empty string");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        if (specification == null) {
            throw new IllegalArgumentException("Specification cannot be null");
        }
        this.registerChild(new JNIDeviceMessage(string, Config.getInternal(config), Specification.getInternal(specification)));
    }

    public DeviceMessage(String string) throws IllegalArgumentException, GMSEC_Exception {
        super((JNIMistMessage)null);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Data cannot be null, nor an empty string");
        }
        this.registerChild(new JNIDeviceMessage(string));
    }

    public DeviceMessage(DeviceMessage deviceMessage) throws IllegalArgumentException {
        super((JNIMistMessage)null);
        if (deviceMessage == null) {
            throw new IllegalArgumentException("DeviceMessage cannot be null");
        }
        this.registerChild(new JNIDeviceMessage((JNIDeviceMessage)MistMessage.getInternal(deviceMessage)));
    }

    public void addDevice(Device device) throws IllegalArgumentException {
        if (device == null) {
            throw new IllegalArgumentException("Device is null");
        }
        ((JNIDeviceMessage)MistMessage.getInternal(this)).addDevice(Device.getInternal(device));
    }

    public int getNumDevices() {
        return ((JNIDeviceMessage)MistMessage.getInternal(this)).getNumDevices();
    }

    public Device getDevice(int n) throws GMSEC_Exception {
        return ((JNIDeviceMessage)MistMessage.getInternal(this)).getDevice(n);
    }

    public DeviceIterator getDeviceIterator() {
        return ((JNIDeviceMessage)MistMessage.getInternal(this)).getDeviceIterator();
    }

    public static DeviceMessage convertMessage(Message message) throws IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        return JNIDeviceMessage.convertMessage(Message.getInternal(message));
    }
}

