/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.mist;

import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIProductFile;

public class ProductFile {
    private JNIProductFile m_jniProductFile = null;

    public static JNIProductFile getInternal(ProductFile productFile) {
        return productFile == null ? null : productFile.m_jniProductFile;
    }

    public ProductFile(JNIProductFile jNIProductFile) {
        this.m_jniProductFile = jNIProductFile;
    }

    protected ProductFile() {
    }

    public ProductFile(String string, String string2, String string3, String string4, String string5) throws IllegalArgumentException {
        this.validateParameters(string, string2, string3, string4);
        if (string5 == null) {
            throw new IllegalArgumentException("ProductFile URI cannot be null");
        }
        this.m_jniProductFile = new JNIProductFile(string, string2, string3, string4, string5);
    }

    public ProductFile(String string, String string2, String string3, String string4, byte[] byArray) throws IllegalArgumentException {
        this.validateParameters(string, string2, string3, string4);
        if (byArray == null) {
            throw new IllegalArgumentException("ProductFile data byte array is null");
        }
        this.m_jniProductFile = new JNIProductFile(string, string2, string3, string4, byArray);
    }

    public ProductFile(ProductFile productFile) throws IllegalArgumentException {
        if (productFile == null) {
            throw new IllegalArgumentException("ProductFile is null");
        }
        this.m_jniProductFile = new JNIProductFile(ProductFile.getInternal(productFile));
    }

    public String getName() {
        return this.m_jniProductFile.getName();
    }

    public String getDescription() {
        return this.m_jniProductFile.getDescription();
    }

    public String getVersion() {
        return this.m_jniProductFile.getVersion();
    }

    public String getFormat() {
        return this.m_jniProductFile.getFormat();
    }

    public boolean isURIAvailable() {
        return this.m_jniProductFile.isURIAvailable();
    }

    public String getURI() throws GMSEC_Exception {
        return this.m_jniProductFile.getURI();
    }

    public boolean contentsAvailable() {
        return this.m_jniProductFile.contentsAvailable();
    }

    public byte[] getContents() throws GMSEC_Exception {
        return this.m_jniProductFile.getContents();
    }

    private void validateParameters(String string, String string2, String string3, String string4) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("ProductFile name is null or an contains an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("ProductFile description is null or an contains an empty string");
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("ProductFile version is null or an contains an empty string");
        }
        if (string4 == null || string4.isEmpty()) {
            throw new IllegalArgumentException("ProductFile format is null or an contains an empty string");
        }
    }
}

