/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.mist;

import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIDevice;
import gov.nasa.gsfc.gmsec.api.mist.DeviceParam;
import java.util.List;

public class Device {
    private JNIDevice m_jniDevice = null;

    public static JNIDevice getInternal(Device device) {
        return device == null ? null : device.m_jniDevice;
    }

    public Device(JNIDevice jNIDevice) {
        this.m_jniDevice = jNIDevice;
    }

    protected Device() {
    }

    public Device(String string, DeviceStatus deviceStatus) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Device name is null or contain an empty-string");
        }
        this.m_jniDevice = new JNIDevice(string, deviceStatus);
    }

    public Device(String string, DeviceStatus deviceStatus, List<DeviceParam> list) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Device name is null or contain an empty-string");
        }
        if (list == null) {
            throw new IllegalArgumentException("DeviceParam list is null");
        }
        this.m_jniDevice = new JNIDevice(string, deviceStatus, list);
    }

    public Device(Device device) throws IllegalArgumentException {
        if (device == null) {
            throw new IllegalArgumentException("Device is null");
        }
        this.m_jniDevice = new JNIDevice(Device.getInternal(device));
    }

    public String getName() {
        return this.m_jniDevice.getName();
    }

    public boolean numberAvailable() {
        return this.m_jniDevice.numberAvailable();
    }

    public Field getNumber() throws GMSEC_Exception {
        return this.m_jniDevice.getNumber();
    }

    public void setNumber(Field field) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("Device number field is null");
        }
        this.m_jniDevice.setNumber(field);
    }

    public boolean modelAvailable() {
        return this.m_jniDevice.modelAvailable();
    }

    public String getModel() throws GMSEC_Exception {
        return this.m_jniDevice.getModel();
    }

    public void setModel(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Device Model is null or contain an empty string");
        }
        this.m_jniDevice.setModel(string);
    }

    public boolean serialAvailable() {
        return this.m_jniDevice.serialAvailable();
    }

    public String getSerial() throws GMSEC_Exception {
        return this.m_jniDevice.getSerial();
    }

    public void setSerial(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Device Serial is null or contain an empty string");
        }
        this.m_jniDevice.setSerial(string);
    }

    public boolean versionAvailable() {
        return this.m_jniDevice.versionAvailable();
    }

    public String getVersion() throws GMSEC_Exception {
        return this.m_jniDevice.getVersion();
    }

    public void setVersion(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Device Version is null or contain an empty string");
        }
        this.m_jniDevice.setVersion(string);
    }

    public boolean groupAvailable() {
        return this.m_jniDevice.groupAvailable();
    }

    public String getGroup() throws GMSEC_Exception {
        return this.m_jniDevice.getGroup();
    }

    public void setGroup(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Device Group is null or contain an empty string");
        }
        this.m_jniDevice.setGroup(string);
    }

    public boolean roleAvailable() {
        return this.m_jniDevice.roleAvailable();
    }

    public String getRole() throws GMSEC_Exception {
        return this.m_jniDevice.getRole();
    }

    public void setRole(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Device Role is null or contain an empty string");
        }
        this.m_jniDevice.setRole(string);
    }

    public DeviceStatus getStatus() {
        return this.m_jniDevice.getStatus();
    }

    public void setStatus(DeviceStatus deviceStatus) {
        this.m_jniDevice.setStatus(deviceStatus);
    }

    public boolean infoAvailable() {
        return this.m_jniDevice.infoAvailable();
    }

    public Field getInfo() throws GMSEC_Exception {
        return this.m_jniDevice.getInfo();
    }

    public void setInfo(Field field) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("Device Info Field is null");
        }
        this.m_jniDevice.setInfo(field);
    }

    public long getParamCount() {
        return this.m_jniDevice.getParamCount();
    }

    public DeviceParam getParam(long l) throws GMSEC_Exception {
        return this.m_jniDevice.getParam(l);
    }

    public void addParam(DeviceParam deviceParam) throws IllegalArgumentException {
        if (deviceParam == null) {
            throw new IllegalArgumentException("DeviceParam is null");
        }
        this.m_jniDevice.addParam(deviceParam);
    }

    public static enum DeviceStatus {
        DEBUG,
        NOMINAL_GREEN,
        YELLOW,
        ORANGE,
        RED;

    }
}

