/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni.mist;

import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIField;
import gov.nasa.gsfc.gmsec.api.jni.JNIFieldConverter;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import gov.nasa.gsfc.gmsec.api.mist.MnemonicSample;

public class JNIMnemonicSample {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected JNIMnemonicSample(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_MnemonicSample(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIMnemonicSample jNIMnemonicSample) {
        return jNIMnemonicSample == null ? 0L : jNIMnemonicSample.swigCPtr;
    }

    public JNIMnemonicSample(String string, Field field) {
        this(gmsecJNI.new_MnemonicSample(string, JNIField.getCPtr(Field.getInternal(field)), Field.getInternal(field)), true);
    }

    public JNIMnemonicSample(JNIMnemonicSample jNIMnemonicSample) {
        this(gmsecJNI.new_MnemonicSample_Copy(JNIMnemonicSample.getCPtr(jNIMnemonicSample), jNIMnemonicSample), true);
    }

    public String getTimestamp() {
        return gmsecJNI.MnemonicSample_GetTimestamp(this.swigCPtr, this);
    }

    public Field getRawValue() {
        long l = gmsecJNI.MnemonicSample_GetRawValue(this.swigCPtr, this);
        return JNIFieldConverter.createFieldReference(l);
    }

    public boolean hasEUValue() {
        return gmsecJNI.MnemonicSample_HasEUValue(this.swigCPtr, this);
    }

    public Field getEUValue() throws GMSEC_Exception {
        long l = gmsecJNI.MnemonicSample_GetEUValue(this.swigCPtr, this);
        return JNIFieldConverter.createFieldReference(l);
    }

    public void setEUValue(Field field) {
        gmsecJNI.MnemonicSample_SetEUValue(this.swigCPtr, this, JNIField.getCPtr(Field.getInternal(field)), Field.getInternal(field));
    }

    public boolean hasTextValue() {
        return gmsecJNI.MnemonicSample_HasTextValue(this.swigCPtr, this);
    }

    public String getTextValue() throws GMSEC_Exception {
        return gmsecJNI.MnemonicSample_GetTextValue(this.swigCPtr, this);
    }

    public void setTextValue(String string) {
        gmsecJNI.MnemonicSample_SetTextValue(this.swigCPtr, this, string);
    }

    public boolean hasFlags() {
        return gmsecJNI.MnemonicSample_HasFlags(this.swigCPtr, this);
    }

    public int getFlags() throws GMSEC_Exception {
        return gmsecJNI.MnemonicSample_GetFlags(this.swigCPtr, this);
    }

    public void setFlags(int n) {
        gmsecJNI.MnemonicSample_SetFlags(this.swigCPtr, this, n);
    }

    public boolean hasLimitEnableDisable() {
        return gmsecJNI.MnemonicSample_HasLimitEnableDisable(this.swigCPtr, this);
    }

    public boolean getLimitEnableDisable() throws GMSEC_Exception {
        return gmsecJNI.MnemonicSample_GetLimitEnableDisable(this.swigCPtr, this);
    }

    public void setLimitEnableDisable(boolean bl) {
        gmsecJNI.MnemonicSample_SetLimitEnableDisable(this.swigCPtr, this, bl);
    }

    public boolean hasLimit() {
        return gmsecJNI.MnemonicSample_HasLimit(this.swigCPtr, this);
    }

    public MnemonicSample.LimitFlag getLimit() throws GMSEC_Exception {
        int n = gmsecJNI.MnemonicSample_GetLimit(this.swigCPtr, this);
        return MnemonicSample.LimitFlag.values()[n];
    }

    public void setLimit(MnemonicSample.LimitFlag limitFlag) {
        gmsecJNI.MnemonicSample_SetLimit(this.swigCPtr, this, limitFlag.ordinal());
    }

    public boolean hasStalenessStatus() {
        return gmsecJNI.MnemonicSample_HasStalenessStatus(this.swigCPtr, this);
    }

    public boolean getStalenessStatus() throws GMSEC_Exception {
        return gmsecJNI.MnemonicSample_GetStalenessStatus(this.swigCPtr, this);
    }

    public void setStalenessStatus(boolean bl) {
        gmsecJNI.MnemonicSample_SetStalenessStatus(this.swigCPtr, this, bl);
    }

    public boolean hasQuality() {
        return gmsecJNI.MnemonicSample_HasQuality(this.swigCPtr, this);
    }

    public boolean getQuality() throws GMSEC_Exception {
        return gmsecJNI.MnemonicSample_GetQuality(this.swigCPtr, this);
    }

    public void setQuality(boolean bl) {
        gmsecJNI.MnemonicSample_SetQuality(this.swigCPtr, this, bl);
    }
}

