/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni.mist;

import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIField;
import gov.nasa.gsfc.gmsec.api.jni.JNIFieldConverter;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import gov.nasa.gsfc.gmsec.api.jni.mist.ArrayListConverter;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIMnemonicSample;
import gov.nasa.gsfc.gmsec.api.mist.MnemonicSample;
import java.util.List;

public class JNIMnemonic {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    public JNIMnemonic(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Mnemonic(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    public static long getCPtr(JNIMnemonic jNIMnemonic) {
        return jNIMnemonic == null ? 0L : jNIMnemonic.swigCPtr;
    }

    public JNIMnemonic(String string, List<MnemonicSample> list) {
        this(gmsecJNI.new_Mnemonic(string, ArrayListConverter.listToMnemonicSamplePtrs(list), ArrayListConverter.listToJNIMnemonicSamples(list), list == null ? 0 : list.size()), true);
    }

    public JNIMnemonic(JNIMnemonic jNIMnemonic) {
        this(gmsecJNI.new_Mnemonic_Copy(jNIMnemonic.swigCPtr, jNIMnemonic), true);
    }

    public String getName() {
        return gmsecJNI.Mnemonic_GetName(this.swigCPtr, this);
    }

    public boolean statusAvailable() {
        return gmsecJNI.Mnemonic_StatusAvailable(this.swigCPtr, this);
    }

    public Field getStatus() throws GMSEC_Exception {
        long l = gmsecJNI.Mnemonic_GetStatus(this.swigCPtr, this);
        return JNIFieldConverter.createFieldReference(l);
    }

    public void setStatus(Field field) {
        JNIField jNIField = Field.getInternal(field);
        gmsecJNI.Mnemonic_SetStatus(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
    }

    public boolean unitsAvailable() {
        return gmsecJNI.Mnemonic_UnitsAvailable(this.swigCPtr, this);
    }

    public String getUnits() throws GMSEC_Exception {
        return gmsecJNI.Mnemonic_GetUnits(this.swigCPtr, this);
    }

    public void setUnits(String string) {
        gmsecJNI.Mnemonic_SetUnits(this.swigCPtr, this, string);
    }

    public long getSampleCount() {
        return gmsecJNI.Mnemonic_GetSampleCount(this.swigCPtr, this);
    }

    public MnemonicSample getSample(long l) throws GMSEC_Exception {
        long l2 = gmsecJNI.Mnemonic_GetSample(this.swigCPtr, this, l);
        return new MnemonicSample(new JNIMnemonicSample(l2, true));
    }

    public void addSample(MnemonicSample mnemonicSample) {
        JNIMnemonicSample jNIMnemonicSample = MnemonicSample.getInternal(mnemonicSample);
        gmsecJNI.Mnemonic_AddSample(this.swigCPtr, this, JNIMnemonicSample.getCPtr(jNIMnemonicSample), jNIMnemonicSample);
    }
}

