/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni.mist;

import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIField;
import gov.nasa.gsfc.gmsec.api.jni.JNIFieldConverter;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import gov.nasa.gsfc.gmsec.api.jni.mist.ArrayListConverter;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIDeviceParam;
import gov.nasa.gsfc.gmsec.api.mist.Device;
import gov.nasa.gsfc.gmsec.api.mist.DeviceParam;
import java.util.List;

public class JNIDevice {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    public JNIDevice(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Device(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    public static long getCPtr(JNIDevice jNIDevice) {
        return jNIDevice == null ? 0L : jNIDevice.swigCPtr;
    }

    public JNIDevice(String string, Device.DeviceStatus deviceStatus) {
        this(gmsecJNI.new_Device(string, deviceStatus.ordinal()), true);
    }

    public JNIDevice(String string, Device.DeviceStatus deviceStatus, List<DeviceParam> list) {
        this(gmsecJNI.new_Device(string, deviceStatus.ordinal(), ArrayListConverter.listToDeviceParamPtrs(list), ArrayListConverter.listToJNIDeviceParams(list), list == null ? 0 : list.size()), true);
    }

    public JNIDevice(JNIDevice jNIDevice) {
        this(gmsecJNI.new_Device_Copy(JNIDevice.getCPtr(jNIDevice), jNIDevice), true);
    }

    public String getName() {
        return gmsecJNI.Device_GetName(this.swigCPtr, this);
    }

    public boolean numberAvailable() {
        return gmsecJNI.Device_NumberAvailable(this.swigCPtr, this);
    }

    public Field getNumber() {
        long l = gmsecJNI.Device_GetNumber(this.swigCPtr, this);
        return JNIFieldConverter.createFieldReference(l);
    }

    public void setNumber(Field field) {
        JNIField jNIField = Field.getInternal(field);
        gmsecJNI.Device_SetNumber(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
    }

    public boolean modelAvailable() {
        return gmsecJNI.Device_ModelAvailable(this.swigCPtr, this);
    }

    public String getModel() {
        return gmsecJNI.Device_GetModel(this.swigCPtr, this);
    }

    public void setModel(String string) {
        gmsecJNI.Device_SetModel(this.swigCPtr, this, string);
    }

    public boolean serialAvailable() {
        return gmsecJNI.Device_SerialAvailable(this.swigCPtr, this);
    }

    public String getSerial() {
        return gmsecJNI.Device_GetSerial(this.swigCPtr, this);
    }

    public void setSerial(String string) {
        gmsecJNI.Device_SetSerial(this.swigCPtr, this, string);
    }

    public boolean versionAvailable() {
        return gmsecJNI.Device_VersionAvailable(this.swigCPtr, this);
    }

    public String getVersion() {
        return gmsecJNI.Device_GetVersion(this.swigCPtr, this);
    }

    public void setVersion(String string) {
        gmsecJNI.Device_SetVersion(this.swigCPtr, this, string);
    }

    public boolean groupAvailable() {
        return gmsecJNI.Device_GroupAvailable(this.swigCPtr, this);
    }

    public String getGroup() {
        return gmsecJNI.Device_GetGroup(this.swigCPtr, this);
    }

    public void setGroup(String string) {
        gmsecJNI.Device_SetGroup(this.swigCPtr, this, string);
    }

    public boolean roleAvailable() {
        return gmsecJNI.Device_RoleAvailable(this.swigCPtr, this);
    }

    public String getRole() {
        return gmsecJNI.Device_GetRole(this.swigCPtr, this);
    }

    public void setRole(String string) {
        gmsecJNI.Device_SetRole(this.swigCPtr, this, string);
    }

    public Device.DeviceStatus getStatus() {
        int n = gmsecJNI.Device_GetStatus(this.swigCPtr, this);
        return Device.DeviceStatus.values()[n];
    }

    public void setStatus(Device.DeviceStatus deviceStatus) {
        gmsecJNI.Device_SetStatus(this.swigCPtr, this, deviceStatus.ordinal());
    }

    public boolean infoAvailable() {
        return gmsecJNI.Device_InfoAvailable(this.swigCPtr, this);
    }

    public Field getInfo() {
        long l = gmsecJNI.Device_GetInfo(this.swigCPtr, this);
        return JNIFieldConverter.createFieldReference(l);
    }

    public void setInfo(Field field) {
        JNIField jNIField = Field.getInternal(field);
        gmsecJNI.Device_SetInfo(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
    }

    public long getParamCount() {
        return gmsecJNI.Device_GetParamCount(this.swigCPtr, this);
    }

    public DeviceParam getParam(long l) {
        long l2 = gmsecJNI.Device_GetParam(this.swigCPtr, this, l);
        return new DeviceParam(new JNIDeviceParam(l2, false));
    }

    public void addParam(DeviceParam deviceParam) {
        JNIDeviceParam jNIDeviceParam = DeviceParam.getInternal(deviceParam);
        gmsecJNI.Device_AddParam(this.swigCPtr, this, JNIDeviceParam.getCPtr(jNIDeviceParam), jNIDeviceParam);
    }
}

