/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni;

import gov.nasa.gsfc.gmsec.api.Status;
import gov.nasa.gsfc.gmsec.api.StatusClassification;
import gov.nasa.gsfc.gmsec.api.StatusCode;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;

public class JNIStatus
extends Status {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    public JNIStatus(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Status(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIStatus jNIStatus) {
        return jNIStatus == null ? 0L : jNIStatus.swigCPtr;
    }

    public JNIStatus() {
        this(gmsecJNI.new_Status(), true);
    }

    private JNIStatus(int n, int n2, String string, int n3) {
        this(StatusClassification.getUsingValue(n), StatusCode.getUsingValue(n2), string, n3);
    }

    public JNIStatus(StatusClassification statusClassification, StatusCode statusCode, String string) {
        this(statusClassification, statusCode, string, 0);
    }

    public JNIStatus(StatusClassification statusClassification, StatusCode statusCode, String string, int n) {
        this(gmsecJNI.new_Status_Set(statusClassification.getValue(), statusCode.getValue(), string, n), true);
    }

    public JNIStatus(JNIStatus jNIStatus) {
        this(gmsecJNI.new_Status_Copy(JNIStatus.getCPtr(jNIStatus), jNIStatus), true);
    }

    @Override
    public boolean isError() {
        return gmsecJNI.Status_IsError(this.swigCPtr, this) != 0;
    }

    @Override
    public String get() {
        return gmsecJNI.Status_Get(this.swigCPtr, this);
    }

    @Override
    public void set(StatusClassification statusClassification, StatusCode statusCode, String string) {
        this.set(statusClassification, statusCode, string, 0);
    }

    @Override
    public void set(StatusClassification statusClassification, StatusCode statusCode, String string, int n) {
        gmsecJNI.Status_Set(this.swigCPtr, this, statusClassification.getValue(), statusCode.getValue(), string, n);
    }

    @Override
    public StatusClassification getClassification() {
        int n = gmsecJNI.Status_GetClassification(this.swigCPtr, this);
        return StatusClassification.getUsingValue(n);
    }

    @Override
    public void setClassification(StatusClassification statusClassification) {
        gmsecJNI.Status_SetClassification(this.swigCPtr, this, statusClassification.getValue());
    }

    @Override
    public StatusCode getCode() {
        int n = gmsecJNI.Status_GetCode(this.swigCPtr, this);
        return StatusCode.getUsingValue(n);
    }

    @Override
    public void setCode(StatusCode statusCode) {
        gmsecJNI.Status_SetCode(this.swigCPtr, this, statusCode.getValue());
    }

    @Override
    public String getReason() {
        return gmsecJNI.Status_GetReason(this.swigCPtr, this);
    }

    @Override
    public void setReason(String string) {
        gmsecJNI.Status_SetReason(this.swigCPtr, this, string);
    }

    @Override
    public int getCustomCode() {
        return gmsecJNI.Status_GetCustomCode(this.swigCPtr, this);
    }

    @Override
    public void setCustomCode(int n) {
        gmsecJNI.Status_SetCustomCode(this.swigCPtr, this, n);
    }

    @Override
    public void reset() {
        gmsecJNI.Status_Reset(this.swigCPtr, this);
    }
}

