/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni;

import gov.nasa.gsfc.gmsec.api.Callback;
import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.Connection;
import gov.nasa.gsfc.gmsec.api.EventCallback;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.ReplyCallback;
import gov.nasa.gsfc.gmsec.api.SubscriptionInfo;
import gov.nasa.gsfc.gmsec.api.jni.JNICallback;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfig;
import gov.nasa.gsfc.gmsec.api.jni.JNIEventCallback;
import gov.nasa.gsfc.gmsec.api.jni.JNIMessage;
import gov.nasa.gsfc.gmsec.api.jni.JNIReplyCallback;
import gov.nasa.gsfc.gmsec.api.jni.JNISubscriptionInfo;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JNIConnection {
    public Connection extconn;
    public long swigCPtr;
    public boolean swigCMemOwn;
    private List<SubscriptionInfo> subscriptions;
    private List<EventCallback> eventCallbacks;

    void setExternal(Connection connection) {
        this.extconn = connection;
    }

    protected JNIConnection(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
        this.subscriptions = Collections.synchronizedList(new ArrayList());
        this.eventCallbacks = new ArrayList<EventCallback>();
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.Connection_Destroy(this.swigCPtr, this);
        }
        this.subscriptions.clear();
        this.eventCallbacks.clear();
        this.extconn = null;
        this.swigCPtr = 0L;
        this.swigCMemOwn = false;
        this.subscriptions = null;
        this.eventCallbacks = null;
    }

    protected static long getCPtr(JNIConnection jNIConnection) {
        return jNIConnection == null ? 0L : jNIConnection.swigCPtr;
    }

    public static Connection create(Config config) throws GMSEC_Exception {
        JNIConfig jNIConfig = Config.getInternal(config);
        JNIConnection jNIConnection = new JNIConnection(0L, false);
        long l = gmsecJNI.Connection_Create(JNIConfig.getCPtr(jNIConfig), jNIConfig, jNIConnection);
        Connection connection = null;
        if (l != 0L) {
            connection = new Connection(jNIConnection);
            jNIConnection.setExternal(connection);
        }
        return connection;
    }

    public static void destroy(Connection connection) {
        JNIConnection jNIConnection = Connection.getInternal(connection);
        gmsecJNI.Connection_Destroy(JNIConnection.getCPtr(jNIConnection), jNIConnection);
        jNIConnection.swigCPtr = 0L;
        jNIConnection.swigCMemOwn = false;
    }

    public static String getAPIVersion() {
        return gmsecJNI.Connection_GetAPIVersion();
    }

    public void connect() {
        gmsecJNI.Connection_Connect(this.swigCPtr, this);
    }

    public void disconnect() {
        gmsecJNI.Connection_Disconnect(this.swigCPtr, this);
    }

    public Connection.ConnectionState getState() {
        int n = gmsecJNI.Connection_GetState(this.swigCPtr, this);
        return Connection.ConnectionState.values()[n];
    }

    public String getLibraryRootName() {
        return gmsecJNI.Connection_GetLibraryRootName(this.swigCPtr, this);
    }

    public String getLibraryVersion() {
        return gmsecJNI.Connection_GetLibraryVersion(this.swigCPtr, this);
    }

    public void registerEventCallback(Connection.ConnectionEvent connectionEvent, EventCallback eventCallback) {
        eventCallback.setConnection(this);
        long l = JNIEventCallback.getCPtr(EventCallback.getInternal(eventCallback));
        gmsecJNI.Connection_RegisterEventCallback(this.swigCPtr, this, connectionEvent.ordinal(), l);
        if (this.eventCallbacks.indexOf(eventCallback) == -1) {
            this.eventCallbacks.add(eventCallback);
        }
    }

    public SubscriptionInfo subscribe(String string) {
        long l = gmsecJNI.Connection_Subscribe(this.swigCPtr, this, string);
        if (l != 0L) {
            return new SubscriptionInfo(new JNISubscriptionInfo(l, false, string, null));
        }
        return null;
    }

    public SubscriptionInfo subscribe(String string, Callback callback) {
        callback.setConnection(this);
        long l = JNICallback.getCPtr(Callback.getInternal(callback));
        long l2 = gmsecJNI.Connection_Subscribe(this.swigCPtr, this, string, l);
        if (l2 != 0L) {
            SubscriptionInfo subscriptionInfo = new SubscriptionInfo(new JNISubscriptionInfo(l2, false, string, callback));
            this.subscriptions.add(subscriptionInfo);
            return subscriptionInfo;
        }
        return null;
    }

    public SubscriptionInfo subscribe(String string, Config config) {
        JNIConfig jNIConfig = Config.getInternal(config);
        long l = gmsecJNI.Connection_Subscribe(this.swigCPtr, this, string, JNIConfig.getCPtr(jNIConfig), jNIConfig);
        if (l != 0L) {
            return new SubscriptionInfo(new JNISubscriptionInfo(l, false, string, null));
        }
        return null;
    }

    public SubscriptionInfo subscribe(String string, Config config, Callback callback) {
        callback.setConnection(this);
        JNIConfig jNIConfig = Config.getInternal(config);
        long l = JNICallback.getCPtr(Callback.getInternal(callback));
        long l2 = gmsecJNI.Connection_Subscribe(this.swigCPtr, this, string, JNIConfig.getCPtr(jNIConfig), jNIConfig, l);
        if (l2 != 0L) {
            SubscriptionInfo subscriptionInfo = new SubscriptionInfo(new JNISubscriptionInfo(l2, false, string, callback));
            this.subscriptions.add(subscriptionInfo);
            return subscriptionInfo;
        }
        return null;
    }

    public void unsubscribe(SubscriptionInfo subscriptionInfo) {
        JNISubscriptionInfo jNISubscriptionInfo = SubscriptionInfo.getInternal(subscriptionInfo);
        gmsecJNI.Connection_Unsubscribe(this.swigCPtr, this, JNISubscriptionInfo.getCPtr(jNISubscriptionInfo), jNISubscriptionInfo);
        int n = this.subscriptions.indexOf(subscriptionInfo);
        if (n != -1) {
            this.subscriptions.remove(n);
        }
        jNISubscriptionInfo.swigCPtr = 0L;
    }

    public boolean startAutoDispatch() {
        return gmsecJNI.Connection_StartAutoDispatch(this.swigCPtr, this);
    }

    public boolean stopAutoDispatch(boolean bl) {
        return gmsecJNI.Connection_StopAutoDispatch(this.swigCPtr, this, bl);
    }

    public void publish(Message message) {
        JNIMessage jNIMessage = Message.getInternal(message);
        gmsecJNI.Connection_Publish(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
    }

    public void publish(Message message, Config config) {
        JNIMessage jNIMessage = Message.getInternal(message);
        JNIConfig jNIConfig = Config.getInternal(config);
        gmsecJNI.Connection_Publish(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIConfig.getCPtr(jNIConfig), jNIConfig);
    }

    public void request(Message message, int n, ReplyCallback replyCallback, int n2) {
        replyCallback.setConnection(this);
        long l = JNIReplyCallback.getCPtr(ReplyCallback.getInternal(replyCallback));
        JNIMessage jNIMessage = Message.getInternal(message);
        gmsecJNI.Connection_Request(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n, l, n2);
    }

    public Message request(Message message, int n, int n2) {
        JNIMessage jNIMessage = Message.getInternal(message);
        long l = gmsecJNI.Connection_Request(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n, n2);
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }

    public void cancelRequest(ReplyCallback replyCallback) {
        if (replyCallback.getConnection() != this) {
            return;
        }
        long l = JNIReplyCallback.getCPtr(ReplyCallback.getInternal(replyCallback));
        gmsecJNI.Connection_CancelRequest(this.swigCPtr, this, l);
    }

    public void reply(Message message, Message message2) {
        JNIMessage jNIMessage = Message.getInternal(message);
        JNIMessage jNIMessage2 = Message.getInternal(message2);
        gmsecJNI.Connection_Reply(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIMessage.getCPtr(jNIMessage2), jNIMessage2);
    }

    public void dispatch(Message message) {
        JNIMessage jNIMessage = Message.getInternal(message);
        gmsecJNI.Connection_Dispatch(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
    }

    public Message receive() {
        long l = gmsecJNI.Connection_Receive(this.swigCPtr, this, -1);
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }

    public Message receive(int n) {
        long l = gmsecJNI.Connection_Receive(this.swigCPtr, this, n);
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }

    public void excludeSubject(String string) {
        gmsecJNI.Connection_ExcludeSubject(this.swigCPtr, this, string);
    }

    public void removeExcludedSubject(String string) {
        gmsecJNI.Connection_RemoveExcludedSubject(this.swigCPtr, this, string);
    }

    public String getName() {
        return gmsecJNI.Connection_GetName(this.swigCPtr, this);
    }

    public void setName(String string) {
        gmsecJNI.Connection_SetName(this.swigCPtr, this, string);
    }

    public String getID() {
        return gmsecJNI.Connection_GetID(this.swigCPtr, this);
    }

    public String getMWInfo() {
        return gmsecJNI.Connection_GetMWInfo(this.swigCPtr, this);
    }

    public long getPublishQueueMessageCount() {
        return gmsecJNI.Connection_GetPublishQueueMessageCount(this.swigCPtr, this);
    }

    public static void shutdownAllMiddlewares() {
        gmsecJNI.Connection_ShutdownAllMiddlewares();
    }

    public static void shutdownMiddleware(String string) {
        gmsecJNI.Connection_ShutdownMiddleware(string);
    }
}

