/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api;

import gov.nasa.gsfc.gmsec.api.StatusClassification;
import gov.nasa.gsfc.gmsec.api.StatusCode;

public class Status {
    private StatusClassification m_class;
    private StatusCode m_code;
    private String m_reason;
    private int m_customCode;

    public Status() {
        this(StatusClassification.NO_ERROR, StatusCode.NO_ERROR_CODE, "", 0);
    }

    public Status(StatusClassification statusClassification, StatusCode statusCode, String string) {
        this(statusClassification, statusCode, string, 0);
    }

    public Status(StatusClassification statusClassification, StatusCode statusCode, String string, int n) {
        this.m_class = statusClassification;
        this.m_code = statusCode;
        this.m_reason = string;
        this.m_customCode = n;
    }

    public Status(Status status) {
        if (status != null) {
            this.m_class = status.m_class;
            this.m_code = status.m_code;
            this.m_reason = status.m_reason;
            this.m_customCode = status.m_customCode;
        }
    }

    public boolean isError() {
        return this.m_class != StatusClassification.NO_ERROR;
    }

    public String get() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.m_class.getValue()).append(",").append(this.m_code.getValue()).append(",").append(this.m_customCode).append("] : ").append(this.m_reason);
        return stringBuilder.toString();
    }

    public void set(StatusClassification statusClassification, StatusCode statusCode, String string) {
        this.set(statusClassification, statusCode, string, 0);
    }

    public void set(StatusClassification statusClassification, StatusCode statusCode, String string, int n) {
        this.m_class = statusClassification;
        this.m_code = statusCode;
        this.m_reason = string == null ? "" : string;
        this.m_customCode = n;
    }

    public StatusClassification getClassification() {
        return this.m_class;
    }

    public void setClassification(StatusClassification statusClassification) {
        this.m_class = statusClassification;
    }

    public StatusCode getCode() {
        return this.m_code;
    }

    public void setCode(StatusCode statusCode) {
        this.m_code = statusCode;
    }

    public String getReason() {
        return this.m_reason;
    }

    public void setReason(String string) {
        this.m_reason = string;
    }

    public int getCustomCode() {
        return this.m_customCode;
    }

    public void setCustomCode(int n) {
        this.m_customCode = n;
    }

    public void reset() {
        this.m_class = StatusClassification.NO_ERROR;
        this.m_code = StatusCode.NO_ERROR_CODE;
        this.m_reason = "";
        this.m_customCode = 0;
    }
}

