/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.Client;
import bolt.Log;
import java.util.logging.Logger;

public class Options {
    static final Logger source = Log.createSource("Options");
    public static final int REPORT_n = 1000;
    public static final int DEFAULT_PORT = 9100;
    static final int CLIENTS_PER_MANAGER = 64;
    static final int DEFAULT_PROCESSOR_QUEUE = 16;
    static final int DEFAULT_DISTRIBUTOR_QUEUE = 16;
    static final int DEFAULT_ = 10000;
    int port = 9100;
    int inputBufferSize = 1024000;
    int outputBufferSize = 1024000;
    int maxMessageSize = 0xA00000;
    int inputBufferLimit = 0x1400000;
    int clientsPerManager = 64;
    int selectionTimeout_ms = 2000;
    int backlogSize = 50;
    int inactivityInterval_ms = 8000;
    int inactivityTimeout_ms = 20000;

    void initialize(Client.Options options) {
        options.inputBufferSize = this.inputBufferSize;
        options.outputBufferSize = this.outputBufferSize;
        options.maxMessageSize = this.maxMessageSize;
        options.inactivityTimeout_ms = this.inactivityTimeout_ms;
    }

    boolean usage(String string) {
        Log.warning(source, string);
        Log.monitor(source, "\nusage: <progname> [key=value]...\n\nknown key/values are\n\tport=<integer>\n\tmaxMessageSize=<integer>\n\tinputBufferSize=<integer>\n\toutputBufferSize=<integer>\n\tinputBufferLimit=<integer>\n\tclientsPerManager=<integer>\n\tselectionTimeout_ms=<integer>\n\tinactivityInterval_ms=<integer>\n\tinactivityTimeout_ms=<integer>\n\tbacklogSize=<integer>");
        return false;
    }

    boolean parse(String[] stringArray) {
        for (String string : stringArray) {
            int n = string.indexOf(61);
            if (n == -1) {
                return this.usage("invalid argument " + string);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equalsIgnoreCase("port")) {
                this.port = Integer.parseInt(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("maxMessageSize")) {
                this.maxMessageSize = Integer.parseInt(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("inputBufferSize")) {
                this.inputBufferSize = Integer.parseInt(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("outputBufferSize")) {
                this.outputBufferSize = Integer.parseInt(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("clientsPerManager")) {
                this.clientsPerManager = Integer.parseInt(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("inputBufferLimit")) {
                this.inputBufferLimit = Integer.parseInt(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("inactivityInterval_ms")) {
                this.inactivityInterval_ms = Integer.parseInt(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("inactivityTimeout_ms")) {
                this.inactivityTimeout_ms = Integer.parseInt(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("selectionTimeout_ms")) {
                this.selectionTimeout_ms = Integer.parseInt(string3);
                continue;
            }
            if (string2.equalsIgnoreCase("backlogSize")) {
                this.backlogSize = Integer.parseInt(string3);
                continue;
            }
            return this.usage("unknown option " + string);
        }
        return true;
    }
}

