/*
 * Decompiled with CFR 0.152.
 */
package bolt;

public enum MessageType {
    VOID(0),
    WELCOME(1),
    GOODBYE(2),
    ECHO(3),
    ERROR(4),
    ACK(5),
    NEGOTIATE(10),
    STATISTICS(11),
    SUBSCRIBE(20),
    UNSUBSCRIBE(21),
    PUBLISH(22){

        @Override
        boolean isDistributable() {
            return true;
        }
    }
    ,
    REQUEST(23){

        @Override
        boolean isDistributable() {
            return true;
        }
    }
    ,
    REPLY(24){

        @Override
        boolean isDistributable() {
            return true;
        }
    };

    private int identifier;

    private MessageType(int n2) {
        this.identifier = n2;
    }

    int identifier() {
        return this.identifier;
    }

    boolean isDistributable() {
        return false;
    }

    static MessageType find(int n) {
        for (MessageType messageType : MessageType.values()) {
            if (messageType.identifier != n) continue;
            return messageType;
        }
        return VOID;
    }
}

