/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.Log;
import bolt.MessageType;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class Header {
    static final int FLAG_META = 1;
    static final int FLAG_BODY = 2;
    public static final int SIZE = 8;
    static final byte SYNC = -75;
    private static Logger source = Log.createSource("Header");
    private int size = -1;
    private MessageType type;
    private int sync;
    private int flags;

    Header() {
        this(MessageType.VOID);
    }

    public Header(MessageType messageType) {
        this.type = messageType;
        this.sync = -75;
        this.flags = 0;
    }

    public static Header parse(ByteBuffer byteBuffer) {
        assert (byteBuffer.capacity() == 8 && byteBuffer.position() == 0);
        Header header = new Header();
        header.size = byteBuffer.getInt();
        if (header.size < 0) {
            Log.error(source, "invalid message size " + header.size);
            return null;
        }
        byte by = byteBuffer.get();
        header.type = MessageType.find(by);
        if (header.type == null) {
            Log.error(source, "invalid message type " + (Object)((Object)header.type));
            return null;
        }
        header.sync = byteBuffer.get();
        if (header.sync != -75) {
            Log.error(source, "lost message sync " + header.sync);
            return null;
        }
        header.flags = byteBuffer.get();
        return header;
    }

    void put(ByteBuffer byteBuffer) {
        assert (byteBuffer.capacity() >= 8 && byteBuffer.position() == 0);
        byteBuffer.putInt(this.size);
        byteBuffer.put((byte)this.type.identifier());
        byteBuffer.put((byte)this.sync);
        byteBuffer.put((byte)this.flags);
        byteBuffer.put((byte)0);
    }

    int getSize() {
        return this.size;
    }

    boolean hasMeta() {
        return (this.flags & 1) != 0;
    }

    void setSize(int n) {
        this.size = n;
    }

    void setFlags(int n) {
        this.flags = n;
    }

    public MessageType getType() {
        return this.type;
    }

    public void dump(String string, PrintStream printStream) {
        if (string == null) {
            string = "header:";
        }
        printStream.println(string + " size=" + this.size + " " + (Object)((Object)this.type) + " sync=" + this.sync);
    }
}

