/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.Distributor;
import bolt.FakeDistributor;
import bolt.Header;
import bolt.IOManager;
import bolt.Log;
import bolt.Message;
import bolt.MessageType;
import bolt.Property;
import bolt.RealProcessor;
import bolt.Statistics;
import bolt.Unpacker;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public class Client
implements Unpacker.Target {
    private static int counter;
    private static final boolean DEBUG_IO = false;
    static final boolean DUMP_MESSAGES = false;
    private int id = ++counter;
    private Raw rawView;
    private Cooked messageView;
    private Shared shared;
    private Unpacker unpacker = new Unpacker(this);
    private Options options = new Options();
    private List<String> subscriptions = new LinkedList<String>();
    private boolean cleanedUp = false;
    private Logger source;
    private boolean inactive;
    private long activity_ms = System.currentTimeMillis();

    Client(Shared shared, SocketChannel socketChannel) {
        this.shared = shared;
        this.rawView = new RealRaw(socketChannel);
        this.messageView = new Cooked();
        this.source = Log.createSource(this.toString());
        Log.monitor(this.source, "created");
    }

    Options getOptions() {
        return this.options;
    }

    SocketChannel getChannel() {
        return this.rawView.getChannel();
    }

    boolean hasOutput() {
        return this.rawView.hasOutput();
    }

    int getBufferedInput() {
        return this.rawView.getBufferedInput();
    }

    void readPending(long l) {
        this.rawView.doRead(l);
    }

    void writePending() {
        this.rawView.doWrite();
    }

    void cleanup() {
        if (this.cleanedUp) {
            Log.detail(this.source, "already cleaned");
            return;
        }
        this.cleanedUp = true;
        Distributor distributor = this.shared.distributor;
        this.shared.distributor = new FakeDistributor();
        for (String string : this.subscriptions) {
            distributor.unsubscribe(this, string);
        }
        distributor.prune(this);
        this.subscriptions.clear();
        Raw raw = this.rawView;
        this.rawView = new FakeRaw();
        raw.close();
        this.messageView = null;
        this.shared.manager = null;
    }

    boolean subscribe(Message message) {
        Property property;
        String string = this._subscribe(message.getMeta().getTopic());
        int n = 2;
        while (string == null && (property = message.getMeta().getProperty("TOPIC-" + n)) != null) {
            string = this._subscribe(property.asString());
            ++n;
        }
        Message message2 = message.makeAck();
        if (string != null && message2.getMeta() != null) {
            message2.getMeta().addProperty(Property.createError(string));
        }
        this.output(message2);
        return string == null;
    }

    private String _subscribe(String string) {
        String string2 = this.shared.distributor.subscribe(this, string);
        if (string2 == null) {
            this.subscriptions.add(string);
            Log.info(this.source, this + " subscribed to " + string);
        } else {
            Log.warning(this.source, "_subscribe(" + string + ") => " + string2);
        }
        return string2;
    }

    void unsubscribe(String string) {
        this.shared.distributor.unsubscribe(this, string);
        if (!this.subscriptions.remove(string)) {
            Log.warning(this.source, "unsubscribe: " + this + " invalid topic " + string);
        }
    }

    void output(Message message) {
        Cooked cooked = this.messageView;
        if (cooked != null) {
            cooked.output(message);
            IOManager iOManager = this.shared.manager;
            if (iOManager != null) {
                iOManager.tickle();
            }
        }
    }

    void failed(String string) {
        Log.warning(this.source, "failed: " + string);
        IOManager iOManager = this.shared.manager;
        this.cleanup();
        if (iOManager != null) {
            iOManager.addDeader(this);
        } else {
            Log.warning(this.source, "failed but manager is null");
        }
    }

    public String toString() {
        return "Client[id=" + this.id + ']';
    }

    @Override
    public void consume(Message message) {
        message.decode();
        message.rxTime = System.nanoTime();
        Cooked cooked = this.messageView;
        if (cooked != null) {
            cooked.input(message);
        }
    }

    @Override
    public boolean isAcceptable(Header header) {
        if (header.getSize() > this.options.maxMessageSize) {
            Log.error(this.source, "exceeded maxMessageSize: " + header.getSize() + " > " + this.options.maxMessageSize);
            return false;
        }
        return true;
    }

    void checkActivity(long l) {
        if (this.inactive) {
            long l2 = l - this.activity_ms;
            Log.warning(this.source, "checkActivity: inactive for " + l2 + " [ms]");
            if (l2 > (long)this.options.inactivityTimeout_ms) {
                this.failed("inactivity timeout");
            }
        }
        this.inactive = true;
    }

    class Cooked {
        private double inServerTime;
        private int publishCount;

        Cooked() {
        }

        void input(Message message) {
            message.decode();
            message.setClient(Client.this);
            ((Client)Client.this).shared.statistics.readMessage();
            ((Client)Client.this).shared.processor.enqueue(message);
        }

        void output(Message message) {
            if (message.getHeader().getType() == MessageType.PUBLISH) {
                message.txTime = System.nanoTime();
                long l = message.txTime - message.rxTime;
                this.inServerTime += (double)l;
                ++this.publishCount;
                if (this.publishCount % 1000 == 0) {
                    System.out.format("output(Message): after %d, mean inServerTime=%.2f [ms]\n", this.publishCount, this.inServerTime / (double)this.publishCount / 1000000.0);
                }
            }
            ByteBuffer byteBuffer = message.getEncoded();
            ((Client)Client.this).shared.statistics.sentMessage();
            Client.this.rawView.put(byteBuffer);
        }
    }

    class RealRaw
    implements Raw {
        private SocketChannel channel;
        private ByteBuffer activeOutput;
        private LinkedBlockingQueue<ByteBuffer> queuedOutput = new LinkedBlockingQueue();
        private ByteBuffer activeInput;

        RealRaw(SocketChannel socketChannel) {
            this.channel = socketChannel;
        }

        @Override
        public SocketChannel getChannel() {
            return this.channel;
        }

        @Override
        public void close() {
            SocketChannel socketChannel = this.channel;
            this.channel = null;
            if (socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public int getBufferedInput() {
            if (this.activeInput == null) {
                return 0;
            }
            return this.activeInput.position();
        }

        @Override
        public void doRead(long l) {
            try {
                ByteBuffer byteBuffer = this.activeInput;
                if (byteBuffer == null) {
                    this.activeInput = byteBuffer = ByteBuffer.allocate(((Client)Client.this).options.inputBufferSize);
                }
                int n = byteBuffer.position();
                int n2 = this.channel.read(byteBuffer);
                if (n2 > 0) {
                    Client.this.inactive = false;
                    Client.this.activity_ms = l;
                    ((Client)Client.this).shared.statistics.addBytesRead(n2);
                    if (!Client.this.unpacker.ingest(byteBuffer.array(), n, n2)) {
                        Client.this.failed("bad data format");
                    }
                    if (byteBuffer.remaining() < ((Client)Client.this).options.inputBufferSize / 2) {
                        this.activeInput = null;
                    }
                } else {
                    Log.warning(Client.this.source, "doRead: count=" + n2);
                    if (n2 < 0) {
                        Client.this.failed("read error");
                    }
                }
            }
            catch (IOException iOException) {
                Log.exception(Client.this.source, iOException, false);
                Client.this.failed("read exception");
            }
        }

        @Override
        public void doWrite() {
            this.activeOutput = this.prepareOutput();
            if (this.activeOutput == null) {
                Log.warning(Client.this.source, "no output");
                return;
            }
            if (this.activeOutput.remaining() < 1) {
                Log.warning(Client.this.source, "nothing to write");
                return;
            }
            try {
                int n = this.channel.write(this.activeOutput);
                if (n > 0) {
                    ((Client)Client.this).shared.statistics.addBytesWritten(n);
                    if (this.activeOutput.remaining() == 0) {
                        this.activeOutput = this.queuedOutput.poll();
                    }
                }
            }
            catch (IOException iOException) {
                Log.exception(Client.this.source, iOException);
                Client.this.failed("write exception");
            }
        }

        synchronized ByteBuffer prepareOutput() {
            int n = 0;
            if (this.activeOutput != null) {
                n += this.activeOutput.remaining();
            }
            for (ByteBuffer byteBuffer2 : this.queuedOutput) {
                if (n + byteBuffer2.remaining() > ((Client)Client.this).options.outputBufferSize && n > 0) break;
                n += byteBuffer2.remaining();
            }
            if (n == 0) {
                return null;
            }
            if (this.activeOutput != null && n == this.activeOutput.remaining()) {
                return this.activeOutput;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            if (this.activeOutput != null) {
                byteBuffer.put(this.activeOutput);
            }
            while (byteBuffer.hasRemaining()) {
                try {
                    ByteBuffer byteBuffer2;
                    byteBuffer2 = this.queuedOutput.take();
                    byteBuffer.put(byteBuffer2);
                }
                catch (InterruptedException interruptedException) {}
            }
            byteBuffer.flip();
            return byteBuffer;
        }

        @Override
        public synchronized boolean hasOutput() {
            if (this.activeOutput != null && this.activeOutput.remaining() > 0) {
                return true;
            }
            return this.queuedOutput.size() > 0;
        }

        @Override
        public synchronized void put(ByteBuffer byteBuffer) {
            try {
                if (byteBuffer.remaining() > 0) {
                    ByteBuffer byteBuffer2 = ByteBuffer.wrap(byteBuffer.array());
                    this.queuedOutput.put(byteBuffer2);
                } else {
                    Log.warning(Client.this.source, "ignoring empty buffer");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class FakeRaw
    implements Raw {
        FakeRaw() {
        }

        @Override
        public void put(ByteBuffer byteBuffer) {
        }

        @Override
        public SocketChannel getChannel() {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public int getBufferedInput() {
            return 0;
        }

        @Override
        public boolean hasOutput() {
            return false;
        }

        @Override
        public void doWrite() {
        }

        @Override
        public void doRead(long l) {
        }
    }

    static interface Raw {
        public void put(ByteBuffer var1);

        public SocketChannel getChannel();

        public void close();

        public int getBufferedInput();

        public boolean hasOutput();

        public void doWrite();

        public void doRead(long var1);
    }

    static class Shared {
        IOManager manager;
        Distributor distributor;
        Statistics statistics;
        RealProcessor processor;

        Shared() {
        }
    }

    static class Options {
        int inputBufferSize = 102400;
        int maxMessageSize = 0xA00000;
        int outputBufferSize = 102400;
        int inactivityTimeout_ms = 10000;

        Options() {
        }
    }
}

