/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.jface;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.e4.xwt.internal.core.BindingExpressionPath;
import org.eclipse.e4.xwt.internal.core.ScopeManager;

public class XWTObservableWrapper
implements IObservableMap {
    private IObservableMap delegate;
    private IObservableSet domain;
    private Object control;
    private Object data;
    private String path;
    private List<IMapChangeListener> changeListeners = Collections.EMPTY_LIST;

    public XWTObservableWrapper(IObservableSet domain, Object control, String path) {
        this.control = control;
        this.domain = domain;
        this.path = path;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void addMapChangeListener(IMapChangeListener listener) {
        if (this.delegate == null) {
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = new ArrayList<IMapChangeListener>();
            }
            this.changeListeners.add(listener);
        } else {
            this.delegate.addMapChangeListener(listener);
        }
    }

    public void clear() {
        this.checkDelegated();
        this.delegate.clear();
    }

    public boolean containsKey(Object key) {
        this.checkDelegated();
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.checkDelegated();
        return this.delegate.containsValue(value);
    }

    public Set entrySet() {
        this.checkDelegated();
        return this.delegate.entrySet();
    }

    public boolean equals(Object o) {
        this.checkDelegated();
        return this.delegate.equals(o);
    }

    public Object get(Object key) {
        if (this.data == null) {
            this.data = key;
        }
        this.checkDelegated();
        return this.delegate.get(key);
    }

    public Object getKeyType() {
        this.checkDelegated();
        return this.delegate.getKeyType();
    }

    public Object getValueType() {
        this.checkDelegated();
        return this.delegate.getValueType();
    }

    public int hashCode() {
        this.checkDelegated();
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        this.checkDelegated();
        return this.delegate.isEmpty();
    }

    public Set keySet() {
        this.checkDelegated();
        return this.delegate.keySet();
    }

    public Object put(Object key, Object value) {
        this.checkDelegated();
        return this.delegate.put(key, value);
    }

    public void putAll(Map t) {
        this.checkDelegated();
        this.delegate.putAll(t);
    }

    public Object remove(Object key) {
        this.checkDelegated();
        return this.delegate.remove(key);
    }

    public void removeMapChangeListener(IMapChangeListener listener) {
        if (this.delegate == null) {
            this.changeListeners.remove(listener);
        } else {
            this.delegate.removeMapChangeListener(listener);
        }
    }

    public int size() {
        this.checkDelegated();
        return this.delegate.size();
    }

    public Collection values() {
        this.checkDelegated();
        return this.delegate.values();
    }

    public void addChangeListener(IChangeListener listener) {
        this.checkDelegated();
        this.delegate.addChangeListener(listener);
    }

    public void addDisposeListener(IDisposeListener listener) {
        this.checkDelegated();
        this.delegate.addDisposeListener(listener);
    }

    public void addStaleListener(IStaleListener listener) {
        this.checkDelegated();
        this.delegate.addStaleListener(listener);
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    public Realm getRealm() {
        this.checkDelegated();
        return this.delegate.getRealm();
    }

    public boolean isDisposed() {
        this.checkDelegated();
        return this.delegate.isDisposed();
    }

    public boolean isStale() {
        this.checkDelegated();
        return this.delegate.isStale();
    }

    public void removeChangeListener(IChangeListener listener) {
        this.checkDelegated();
        this.delegate.removeChangeListener(listener);
    }

    public void removeDisposeListener(IDisposeListener listener) {
        this.checkDelegated();
        this.delegate.removeDisposeListener(listener);
    }

    public void removeStaleListener(IStaleListener listener) {
        this.checkDelegated();
        this.delegate.removeStaleListener(listener);
    }

    protected void checkDelegated() {
        if (this.delegate == null) {
            IValueProperty property = ScopeManager.createValueProperty(this.control, this.data, new BindingExpressionPath(this.path));
            this.delegate = property.observeDetail(this.domain);
            for (IMapChangeListener listener : this.changeListeners) {
                this.delegate.addMapChangeListener(listener);
            }
            this.changeListeners.clear();
        }
    }
}

